package edu.unl.consystlab.sudokuSolver;

import java.util.List;
import java.util.LinkedList;

import edu.unl.consystlab.sudokuSolver.consistencyAlgorithms.consistencyAlgorithm;

//used for the redo and undo buttons.

public class user_action {

	private String action;
	private problemVariable variableAffected;
	private String valueAssigned;
	private List domainReductions;
	private List variablesAssigned;

	private consistencyAlgorithm myAlgorithm;
	
	//default constructor not used.
	public user_action()
	{	
		action = null;
		variableAffected = null;
		valueAssigned = null;
		domainReductions = null;
		variablesAssigned = null;
	}
	
	public void user_assign(problemVariable new_variableAffected, List new_reductions)
	{
		action = "assign";
		variableAffected = new_variableAffected;
		domainReductions = new LinkedList(new_reductions);
	}
	
	public void user_consistency(consistencyAlgorithm newAlgorithm)
	{
		action = "consistency";
		myAlgorithm = newAlgorithm;
	}
	
	public void user_assignSingletons(assignSingletons newAssignSingletons)
	{
		action = "autoAssign";
		domainReductions = new LinkedList(newAssignSingletons.getVariableReductions());
		variablesAssigned = new LinkedList(newAssignSingletons.getVariablesAssigned());
	}
	
	public void user_domain_reduction(List newReductions)
	{
		action = "reduction";
		domainReductions = new LinkedList(newReductions);
	}
	
	public List getAssignments()
	{
		return variablesAssigned;
	}
	
	public String getAction()
	{
		return(action);
	}
	
	public void setStringAssigned(String strAssign)
	{
		valueAssigned = strAssign;
	}
	
	public String getStringAssigned()
	{
		return(valueAssigned);
	}
	
	public problemVariable getVariableAffected()
	{
		return(variableAffected);
	}
	
	public List getDomainReductions()
	{
		return(domainReductions);
	}
	
	public consistencyAlgorithm getConsistencyAlgorithm()
	{
		return myAlgorithm;
	}
}
